import matplotlib.pyplot as plt
import matplotlib.patches as patches

# Define grid dimensions
rows, cols = 6, 4

# Create figure and axes
fig, ax = plt.subplots(figsize=(8, 12))

# Define colors for each piece type
colors = {
    'rightl0': 'blue',
    'rightl1': 'green',
    'square0': 'red',
    'square1': 'yellow',
    'clear': 'white'
}

# Draw grid and initialize all as clear
for r in range(rows):
    for c in range(cols):
        ax.add_patch(patches.Rectangle((c, rows-1-r), 1, 1, fill=True, edgecolor='grey', facecolor=colors['clear'], linewidth=1))
        ax.text(c + 0.5, rows-1-r + 0.5, f'f{r}-{c}f\nclear', ha='center', va='center', fontsize=8, color='black')

# Function to draw pieces with bold outer edges
def draw_piece(positions, name, color):
    for (r, c) in positions:
        ax.add_patch(patches.Rectangle((c, rows-1-r), 1, 1, fill=True, edgecolor='black', facecolor=color, linewidth=2))
        ax.text(c + 0.5, rows-1-r + 0.7, name, ha='center', va='center', fontsize=8, color='white')
        ax.text(c + 0.5, rows-1-r + 0.3, 'occupied', ha='center', va='center', fontsize=8, color='white')

# Define piece positions
rightl0_positions = [(3, 0), (3, 1), (2, 0)]
rightl1_positions = [(1, 0), (1, 1), (0, 0)]
square0_position = [(1, 2)]
square1_position = [(2, 2)]

# Draw pieces
draw_piece(rightl0_positions, 'rightl0', colors['rightl0'])
draw_piece(rightl1_positions, 'rightl1', colors['rightl1'])
draw_piece(square0_position, 'square0', colors['square0'])
draw_piece(square1_position, 'square1', colors['square1'])

# Set limits and aspect
ax.set_xlim(0, cols)
ax.set_ylim(0, rows)
ax.set_aspect('equal')

# Add legend
legend_handles = [
    patches.Patch(color=colors['rightl0'], label='rightl0 - occupied'),
    patches.Patch(color=colors['rightl1'], label='rightl1 - occupied'),
    patches.Patch(color=colors['square0'], label='square0 - occupied'),
    patches.Patch(color=colors['square1'], label='square1 - occupied'),
    patches.Patch(color=colors['clear'], label='clear')
]
ax.legend(handles=legend_handles, loc='upper right')

# Remove axes
ax.axis('off')

# Save the figure
plt.savefig('tetris/one_shot/ini_diagram_code/attempts/attempt_34.png', bbox_inches='tight')